#!/usr/bin/perl

# Jose "Buckaroo" de Leon, 7/21/04
# Use as-is, no warranties.

# globals
$site    = $ARGV[0] ;
$sitenum = substr($site,4) ;

sub clean_homevirtual
{
   my (@list) ;
   my ($s) ;

   @list = split(/\n/,`find /home/virtual -type l -maxdepth 1`) ;
   foreach $s (@list) {
      my (@l) ;
      @l = split(/\n/,`readlink $s`) ;
      if ( $l[0] eq "/home/virtual/$site/fst" ) {
         `rm -f $s` ;
      }
   }
   `rm -rf /home/virtual/$site` ;
}

sub clean_appldb
{
   my (@tables) ;
   my ($t) ;

   @tables = split(/\n/,`psql -P format=unaligned  -t -c '\\dt' appldb | cut -f2 -d'|' | egrep -v "siteinfo"`) ;
   foreach $t (@tables) {
      my ($c,@columns) ;
      @columns = split(/\n/,`psql -P format=unaligned -t -c '\\d $t' appldb | cut -f1 -d'|'`) ;
      foreach $c (@columns) {
         if ( $c eq "site_id" ) {
           `psql -c \'delete from $t where site_id=$sitenum\' appldb` ;
         }
      }
   }
   `psql -c \'delete from siteinfo where site_id=$sitenum\' appldb` ;
}

sub clean_mappings()
{
   my (@mapfiles) ;
   my ($f) ;

   # do the map files except apache, skip domainmap.db
   @mapfiles = split(/\n/,`find /etc/virtualhosting/mappings -type f -maxdepth 1 -printf "%f\n" | egrep -v "apache.domainmap|domainmap.db"`) ;
   foreach $f (@mapfiles) {
      my (@mlines,$ln) ;
      open(MF,"/etc/virtualhosting/mappings/$f") ;
      @mlines = <MF> ;
      close(MF) ;
      open(NEWMF,">/etc/virtualhosting/mappings/$f.fastdel") ;
      foreach $ln (@mlines) {
         chomp($ln) ;
         if ( $ln =~ /=\s$site$/ ) {
            next ;
         }
         print NEWMF $ln . "\n" ;
      }
      close(NEWMF) ;
      `mv /etc/virtualhosting/mappings/$f.fastdel /etc/virtualhosting/mappings/$f` ;
   }

   # apache domain map has different format
   my (@mlines,$ln) ;
   open(MF,"/etc/virtualhosting/mappings/apache.domainmap") ;
   @mlines = <MF> ;
   close(MF) ;
   open(NEWMF,">/etc/virtualhosting/mappings/apache.domainmap.fastdel") ;
   foreach $ln (@mlines) {
      chomp($ln) ;
      if ( $ln =~ /=\s$sitenum$/ ) {
         next ;
      }
      print NEWMF $ln . "\n" ;
   }
   close(NEWMF) ;
   `mv /etc/virtualhosting/mappings/apache.domainmap.fastdel /etc/virtualhosting/mappings/apache.domainmap` ;

   # now rebuild domaimmap.db
   `cat /etc/virtualhosting/mappings/domainmap | egrep -v \"DEFAULT\" | /usr/sbin/makemap hash /etc/virtualhosting/mappings/domainmap` ;
}

sub clean_adminuser
{
   my ($a,@alines) ;

   `userdel admin$sitenum` ;
   
   # delete the group too just in case half deleted site
   `groupdel admin$sitenum 2> /dev/null` ;

   open(AF,"/etc/aliases") ;
   @alines = <AF> ;
   close(AF) ;
   open(AF,">/etc/aliases.fastdel") ;
   foreach $a (@alines) {
      chomp($a) ;
      if ( $a =~ /^admin$sitenum:/ ) {
         print "removing $a\n" ;
         next ;
      }
      print AF $a . "\n" ;
   }
   close(AF) ;
   `mv /etc/aliases.fastdel /etc/aliases` ;
   `newaliases` ;
}

sub clean_subdomainconf
{
   `rm -f /etc/virtualhosting/subdomain/$site` ;
}

sub clean_apacheconf
{
   `rm -f /etc/httpd/conf/virtual/$site` ;
   `rm -f /etc/httpd/conf/virtual.preview/$site` ;
   `rm -rf /etc/httpd/conf/$site` ;
   `rm -rf /etc/httpd/conf/$site.preview` ;
}

sub clean_proftpdconf
{
   my ($p,@pconf) ;

   open(AF,"/etc/proftpd/proftpd.conf.wp") ;
   @pconf = <AF> ;
   close(AF) ;
   open(AF,">/etc/proftpd/proftpd.conf.wp.fastdel") ;
   foreach $p (@pconf) {
      chomp($p) ;
      if ( $p =~ /$site$/ ) {
         next ;
      }
      print AF $p . "\n" ;
   }
   close(AF) ;

   `mv /etc/proftpd/proftpd.conf.wp.fastdel /etc/proftpd/proftpd.conf.wp` ;
   `rm -f /etc/proftpd/$site` ;
}

sub clean_mysql
{
   my (@pas) ;
   my (@sa) ;
   my (@dbs) ;

   @pas = split(/\n/,`cd /usr/lib/opcenter/mysql ; python2 -c 'import mysqlbe;print mysqlbe.read_mysqlpass()'`) ;
   @sa = split(/\n/,`egrep "^dbaseadmin" /home/virtual/$site/info/current/mysql | cut -f3 -d' '`) ;
   @dbs = split(/\n/,`mysql -q -r -B -u root -p$pas[0] -e \"select distinct Db from db where user='$sa[0]'\" mysql`) ;
   my ($cnt) ;
   $cnt = 0 ;
   foreach (@dbs) {
      my ($dbnorm) ;
      $cnt = $cnt + 1 ;
      if ( $cnt == 1 ) { next ; }
      $dbnorm = $_ ;
      $dbnorm =~ s/\\_/_/g ;
      `rm -f /var/lib/mysql/$dbnorm` ;
   }
   `mysql -q -r -B -u root -p$pas[0] -e \"delete from db where user='$sa[0]'\" mysql` ;
   `mysql -q -r -B -u root -p$pas[0] -e \"delete from user where user='$sa[0]'\" mysql` ;
}

clean_mysql() ;
clean_homevirtual() ;
clean_appldb() ;
clean_mappings() ;
clean_adminuser() ;
clean_subdomainconf() ;
clean_apacheconf() ;
clean_proftpdconf() ;

